/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.ntfy;

import com.ibm.hwmca.base.ntfy.NotificationConstants;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import java.util.HashMap;
import java.util.Map;

public class ObjectManagerPanelBean
extends PanelBean
implements NotificationConstants {
    private static final String TRACE_MASKT = "XNTYOMPT";
    private static final String TRACE_MASKF = "XNTYOMPF";
    private static final String TRACE_MASKD = "XNTYOMPD";
    private transient ItemDescriptor[] m_idObjectTable;
    private transient ColumnDescriptor[] m_cdObjectTableStructure;
    private int[] m_iObjectTableSelection;
    private Map data;
    public static final String OBJECT_TABLE = "ObjectTable";
    public static final String TASKLET_SELECTED_OBJECT = "TaskletSelectedObject";

    public void panelAction(TaskActionEvent event) {
        Trace.trace(TRACE_MASKT, "-> panelAction()");
        String command = event.getActionCommand();
        PanelTaskletRequest request = new PanelTaskletRequest(this.getClass().getName() + this.getMountPrefix());
        request.setData("CommandSource", "ObjectManagerPanel");
        String object = null;
        LocalizableText obj = null;
        if (this.m_iObjectTableSelection != null && this.m_iObjectTableSelection.length > 0) {
            ItemDescriptor[] row = this.userTaskManager.getRow(this.getMountPrefix() + OBJECT_TABLE, this.m_iObjectTableSelection[0]);
            object = row[0].getTitle();
            Trace.trace(TRACE_MASKF, "looking for: " + object);
            LocalizableText[] objNames = (LocalizableText[])this.data.get(OBJECT_TABLE);
            int i = 0;
            while (i < objNames.length) {
                if (objNames[i].toString().equals(object)) {
                    Trace.trace(TRACE_MASKF, "found it!");
                    obj = objNames[i];
                }
                ++i;
            }
        }
        if (command.equals(this.getMountPrefix() + "OKButton")) {
            request.setData(TASKLET_SELECTED_OBJECT, obj);
            request.setData("CommandName", "OKButton");
        }
        this.postTaskletRequest(request);
        Trace.trace(TRACE_MASKT, "<- panelAction()");
    }

    public void verifyChanges() throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "<> verifyChanges()");
    }

    public void save() {
        Trace.trace(TRACE_MASKT, "<> save()");
    }

    public void prepare() {
        Trace.trace(TRACE_MASKT, "-> prepare()");
        if (this.data == null) {
            this.data = new HashMap();
        } else {
            LocalizableText selectedObject = (LocalizableText)this.data.get(TASKLET_SELECTED_OBJECT);
            LocalizableText[] objects = (LocalizableText[])this.data.get(OBJECT_TABLE);
            if (objects == null) {
                this.data.put(OBJECT_TABLE, new LocalizableText[0]);
            }
            int selectedObjectIndex = -1;
            if (objects != null) {
                int i = 0;
                while (i < objects.length) {
                    if (objects[i] != null && selectedObject != null && selectedObject.equals(objects[i])) {
                        selectedObjectIndex = i;
                        i = objects.length;
                    }
                    ++i;
                }
                if (selectedObjectIndex >= 0) {
                    this.userTaskManager.setSelectedRows(this.getMountPrefix() + OBJECT_TABLE, new int[]{selectedObjectIndex});
                    this.m_iObjectTableSelection = new int[]{selectedObjectIndex};
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- prepare()");
    }

    public void load() {
        this.m_idObjectTable = new ItemDescriptor[0];
        this.m_cdObjectTableStructure = new ColumnDescriptor[0];
        this.m_iObjectTableSelection = new int[0];
    }

    public void setData(Map data) {
        this.data = data;
    }

    public int getObjectTableRowCount() {
        LocalizableText[] objects = (LocalizableText[])this.data.get(OBJECT_TABLE);
        return objects.length;
    }

    public ItemDescriptor[] getObjectTableRowAt(int index) {
        LocalizableText[] objects = (LocalizableText[])this.data.get(OBJECT_TABLE);
        return new ItemDescriptor[]{new ItemDescriptor(this.getMountPrefix() + OBJECT_TABLE + index, objects[index].toString())};
    }

    public ColumnDescriptor[] getObjectTableRowStructure() {
        return this.m_cdObjectTableStructure;
    }

    public int getObjectTableRowStatus() {
        return 3;
    }

    public void setObjectTableRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
        this.m_idObjectTable = items;
    }

    public int[] getObjectTableSelection() {
        return this.m_iObjectTableSelection;
    }

    public void setObjectTableSelection(int[] selected) throws IllegalUserDataException {
        this.m_iObjectTableSelection = selected;
    }
}

